/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.boxes;

import de.willuhn.jameica.gui.boxes.Box;
import de.willuhn.jameica.system.Settings;

public abstract class AbstractBox
implements Box {
    private static Settings settings = new Settings(Box.class);
    private Integer index = null;
    private Boolean enabled = null;

    @Override
    public boolean isEnabled() {
        if (this.enabled == null) {
            this.enabled = settings.getBoolean(this.getClass().getName() + ".enabled", this.getDefaultEnabled());
        }
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        settings.setAttribute(this.getClass().getName() + ".enabled", enabled);
    }

    @Override
    public int getIndex() {
        if (this.index == null) {
            this.index = settings.getInt(this.getClass().getName() + ".index", this.getDefaultIndex());
        }
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
        settings.setAttribute(this.getClass().getName() + ".index", index);
    }

    public int compareTo(Object arg0) {
        int oindex;
        if (arg0 == null || !(arg0 instanceof Box)) {
            return 1;
        }
        Box other = (Box)arg0;
        int index = this.getIndex();
        if (index == (oindex = other.getIndex())) {
            return 0;
        }
        return index > oindex ? 1 : -1;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public int getHeight() {
        return -1;
    }
}

